<?php
/* --------------------------------------------------------------
   DeletionOfMultipleParcelServicesRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Events;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceIds;

/**
 * Class DeletionOfMultipleParcelServicesRequested
 *
 * @package Gambio\Admin\ParcelService\Events
 */
class DeletionOfMultipleParcelServicesRequested
{
    /**
     * @var ParcelServiceIds
     */
    private $parcelServiceIds;
    
    
    /**
     * DeletionOfMultipleParcelServicesRequested constructor.
     *
     * @param ParcelServiceIds $parcelServiceIds
     */
    private function __construct(ParcelServiceIds $parcelServiceIds)
    {
        $this->parcelServiceIds = $parcelServiceIds;
    }
    
    
    /**
     * @param ParcelServiceIds $parcelServiceIds
     *
     * @return DeletionOfMultipleParcelServicesRequested
     */
    public static function create(ParcelServiceIds $parcelServiceIds): DeletionOfMultipleParcelServicesRequested
    {
        return new self($parcelServiceIds);
    }
    
    
    /**
     * @return ParcelServiceIds
     */
    public function parcelServiceIds(): ParcelServiceIds
    {
        return $this->parcelServiceIds;
    }
    
    
    /**
     * @param ParcelServiceIds $parcelServiceIds
     */
    public function replaceParcelServices(ParcelServiceIds $parcelServiceIds): void
    {
        $this->parcelServiceIds = $parcelServiceIds;
    }
}